-- JP-5 fuel	--NIGHTSTORM  3.0840937
local GALLON_TO_KG = 3.785 * 0.81482

--FUEL TANKS START

--Empty CFT's
declare_loadout(
	{
		category		= CAT_FUEL_TANKS,
		CLSID			= "{CFT}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "cft.png",
		Weight_Empty	= 441,
		Weight			= 441 + 0 * GALLON_TO_KG,
		Cx_pil			= 0.00108,
		displayName		= _("Empty CFT*2"),
		
		shape_table_data = 
		{
			{
				name 	= "CFT",
				file	= "CFT";
				life	= 1;
				fire	= { 0, 1};
				username	= "CFT";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "CFT",
			}, 
		}, 
	}
)

--Fuel for Left CFT
declare_loadout(
	{
		category		= CAT_FUEL_TANKS,
		CLSID			= "{CFT_Left}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "left_cft.png",
		Weight_Empty	= 0,
		Weight			= 0 + 221.25 * GALLON_TO_KG,
		Cx_pil			= 0,
		displayName		= _("Conformal fuel tank 225 gal"),
		
		shape_table_data = 
		{
			{
				name 	= "CFT_Left",
				file	= "CFT_Left";
				life	= 1;
				fire	= { 0, 1};
				username	= "CFT_Left";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "null",
			}, 
		}, 
	}
)

--Fuel for Right CFT
declare_loadout(
	{
		category		= CAT_FUEL_TANKS,
		CLSID			= "{CFT_Right}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "right_cft.png",
		Weight_Empty	= 0,
		Weight			= 0 + 221.25 * GALLON_TO_KG,
		Cx_pil			= 0,
		displayName		= _("Conformal fuel tank 225 gal"),
		
		shape_table_data = 
		{
			{
				name 	= "CFT_Right",
				file	= "CFT_Right";
				life	= 1;
				fire	= { 0, 1};
				username	= "CFT_Right";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "null",
			}, 
		}, 
	}
)

--Fuel for Left CFT and 370 gallon tank
declare_loadout(
	{

		category		= CAT_FUEL_TANKS,
		CLSID			= "{CFT_370_Left}",
		attribute	=	{1,	3,	43,	11},	
		Picture			= "left_cft_370.png",
		Weight_Empty	=	215.5,
		Weight			= 	215.5 + 585.25 * GALLON_TO_KG,		
		Cx_pil 			= 0.00175,
		displayName		= _("Fuel tank 370 gal + CFT 225 gal"),
		
		
		Elements	= 
				{
					[1]	=	
					{
						Position	=	{0,	0,	0},
						ShapeName	=	"fuel_tank_370gal",
					}, 
				}, -- end of Elements
	}
)

--Fuel for Right CFT and 370 gallon tank
declare_loadout(
	{

		category		= CAT_FUEL_TANKS,
		CLSID			= "{CFT_370_Right}",
		attribute	=	{1,	3,	43,	11},	
		Picture			= "right_cft_370.png",
		Weight_Empty	=	215.5,
		Weight			= 	215.5 + 585.25 * GALLON_TO_KG,		
		Cx_pil 			= 0.00175,
		displayName		= _("Fuel tank 370 gal + CFT 225 gal"),
		
		
		Elements	= 
				{
					[1]	=	
					{
						Position	=	{0,	0,	0},
						ShapeName	=	"fuel_tank_370gal",
					}, 
				}, -- end of Elements
	}
)

--Empty 300 gallon tank
declare_loadout(
	{

		category		= CAT_FUEL_TANKS,
		CLSID			= "{300_Empty}",
		attribute		=	{1,	3,	43,	12},	
		Picture			= "PTB.png",
		Weight_Empty	=	173.7,
		Weight			=	173.7 + 0 * GALLON_TO_KG,		
		Cx_pil			= 0.0009,
		displayName		= _("Fuel tank 300 gal *EMPTY*"),
		
		
		Elements	= 
				{
					[1]	=	
					{
						Position	=	{0,	0,	0},
						ShapeName	=	"fuel_tank_300gal",
					}, 
				}, -- end of Elements
	}
)

--Empty 370 gallon tank
declare_loadout(
	{

		category		= CAT_FUEL_TANKS,
		CLSID			= "{370_Empty}",
		attribute		=	{1,	3,	43,	11},	
		Picture			= "PTB.png",
		Weight_Empty	=	215.5,
		Weight			= 	215.5 + 0 * GALLON_TO_KG,		
		Cx_pil 			= 0.00175,
		displayName		= _("Fuel tank 370 gal *EMPTY*"),
		
		
		Elements	= 
				{
					[1]	=	
					{
						Position	=	{0,	0,	0},
						ShapeName	=	"fuel_tank_370gal",
					}, 
				}, -- end of Elements
	}
)

--600 gallon tank
declare_loadout(
	{
		category		= CAT_FUEL_TANKS,
		CLSID			= "{600gal}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "PTB.png",
		Weight_Empty	= 180,				--NIGHTSTORM 399 lbs per tank
		Weight			= 180 + 595 * GALLON_TO_KG,
		Cx_pil			= 0.0008,
		displayName		= _("Fuel tank 600 gal"),
		
		shape_table_data = 
		{
			{
				name 	= "600gal",
				file	= "600gal";
				life	= 1;
				fire	= { 0, 1};
				username	= "600gal";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
						Position	=	{0,	0,	0},
						ShapeName	=	"600gal",
			}, 
		}, 
	}
)

--Fuel for Left CFT and 600 gallon tank
declare_loadout(
	{

		category		= CAT_FUEL_TANKS,
		CLSID			= "{CFT_600_Left}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "left_cft_600.png",
		Weight_Empty	=	180,
		Weight			= 	180 + 816.25 * GALLON_TO_KG,	--NIGHTSTORM Avionics limit total fuel to ~17400 lbs	
		Cx_pil			= 0.0008,
		displayName		= _("Fuel tank 600 gal + CFT 225 gal"),
		
		shape_table_data = 
		{
			{
				name 	= "600gal",
				file	= "600gal";
				life	= 1;
				fire	= { 0, 1};
				username	= "600gal";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		
		Elements	= 
				{
					[1]	=	
					{
						Position	=	{0,	0,	0},
						ShapeName	=	"600gal",
					}, 
				}, -- end of Elements
	}
)

--Fuel for Right CFT and 600 gallon tank
declare_loadout(
	{

		category		= CAT_FUEL_TANKS,
		CLSID			= "{CFT_600_Right}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "right_cft_600.png",
		Weight_Empty	=	180,
		Weight			= 	180 + 816.25 * GALLON_TO_KG,		--NIGHTSTORM Avionics limit total fuel to ~17400 lbs	
		Cx_pil			= 0.0008,
		displayName		= _("Fuel tank 600 gal + CFT 225 gal"),
		
		shape_table_data = 
		{
			{
				name 	= "600gal",
				file	= "600gal";
				life	= 1;
				fire	= { 0, 1};
				username	= "600gal";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		
		Elements	= 
				{
					[1]	=	
					{
						Position	=	{0,	0,	0},
						ShapeName	=	"600gal",
					}, 
				}, -- end of Elements
	}
)

--Empty 600 gallon tank
declare_loadout(
	{
		category		= CAT_FUEL_TANKS,
		CLSID			= "{600gal_Empty}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "PTB.png",
		Weight_Empty	= 180,				--NIGHTSTORM 399 lbs per tank
		Weight			= 180 + 0 * GALLON_TO_KG,
		Cx_pil			= 0.0008,
		displayName		= _("Fuel tank 600 gal *EMPTY*"),
		
		shape_table_data = 
		{
			{
				name 	= "600gal_Empty",
				file	= "600gal_Empty";
				life	= 1;
				fire	= { 0, 1};
				username	= "600gal_Empty";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
						Position	=	{0,	0,	0},
						ShapeName	=	"600gal_Empty",
			}, 
		}, 
	}
)

--EQUIPMENT START

--Tail with NO ECM pod
declare_loadout(
	{
		category		= CAT_PODS,
		CLSID			= "{TAIL_0}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "TAIL_0.png",
		Weight_Empty	= 0,
		Weight			= 0,
		Cx_pil			= 0,
		displayName		= _("Tail Extention"),
		
		shape_table_data = 
		{
			{
				name 	= "TAIL_0",
				file	= "TAIL_0";
				life	= 1;
				fire	= { 0, 1};
				username	= "TAIL_0";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "TAIL_0",
			}, 
		}, 
	}
)


--Tail with single ECM pod
declare_loadout(
	{
		category		= CAT_PODS,
		CLSID			= "{TAIL_1}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "TAIL_1.png",
		Weight_Empty	= 0,
		Weight			= 0,
		Cx_pil			= 0,
		displayName		= _("Tail Extention Type 1"),
		
		shape_table_data = 
		{
			{
				name 	= "TAIL_1",
				file	= "TAIL_1";
				life	= 1;
				fire	= { 0, 1};
				username	= "TAIL_1";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "TAIL_1",
			}, 
		}, 
	}
)

--Tail with dual ECM pods
declare_loadout(
	{
		category		= CAT_PODS,
		CLSID			= "{TAIL_2}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "TAIL_2.png",
		Weight_Empty	= 0,
		Weight			= 0,
		Cx_pil			= 0,
		displayName		= _("Tail Extention Type 2"),
		
		shape_table_data = 
		{
			{
				name 	= "TAIL_2",
				file	= "TAIL_2";
				life	= 1;
				fire	= { 0, 1};
				username	= "TAIL_2";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "TAIL_2",
			}, 
		}, 
	}
)

--Tail with dual ECM flat pods
declare_loadout(
	{
		category		= CAT_PODS,
		CLSID			= "{TAIL_3}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "TAIL_3.png",
		Weight_Empty	= 0,
		Weight			= 0,
		Cx_pil			= 0,
		displayName		= _("Tail Extention Type 3"),
		
		shape_table_data = 
		{
			{
				name 	= "TAIL_3",
				file	= "TAIL_3";
				life	= 1;
				fire	= { 0, 1};
				username	= "TAIL_3";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "TAIL_3",
			}, 
		}, 
	}
)

--Tail with dual ECM flat pods used by RNLAF and RNoAF
declare_loadout(
	{
		category		= CAT_PODS,
		CLSID			= "{TAIL_4}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "TAIL_4.png",
		Weight_Empty	= 0,
		Weight			= 0,
		Cx_pil			= 0,
		displayName		= _("Tail Extention Type 4"),
		
		shape_table_data = 
		{
			{
				name 	= "TAIL_4",
				file	= "TAIL_4";
				life	= 1;
				fire	= { 0, 1};
				username	= "TAIL_4";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "TAIL_4",
			}, 
		}, 
	}
)

--Crew boarding ladder for raised canopy
declare_loadout(
	{
		category		= CAT_PODS,
		CLSID			= "{Crew_Ladder}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "Crew_Ladder.png",
		Weight_Empty	= 0,
		Weight			= 0,
		Cx_pil			= 0,
		displayName		= _("Crew Ladder"),
		
		shape_table_data = 
		{
			{
				name 	= "Crew_Ladder",
				file	= "Crew_Ladder";
				life	= 1;
				fire	= { 0, 1};
				username	= "Crew_Ladder";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "Crew_Ladder",
			}, 
		}, 
	}
)

--Ramp start, Crew boarding ladder for raised canopy and covers in place
declare_loadout(
	{
		category		= CAT_PODS,
		CLSID			= "{RampStart}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "Crew_Ladder.png",
		Weight_Empty	= 0,
		Weight			= 0,
		Cx_pil			= 0,
		displayName		= _("Ramp Start Aircraft"),
		
		shape_table_data = 
		{
			{
				name 	= "RampStart",
				file	= "RampStart";
				life	= 1;
				fire	= { 0, 1};
				username	= "RampStart";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "RampStart",
			}, 
		}, 
	}
)

--Parked aircraft, for canopy lowered and covers in place
declare_loadout(
	{
		category		= CAT_PODS,
		CLSID			= "{Parked}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "Parked.png",
		Weight_Empty	= 0,
		Weight			= 0,
		Cx_pil			= 0,
		displayName		= _("Parked Aircraft"),
		
		shape_table_data = 
		{
			{
				name 	= "Parked",
				file	= "Parked";
				life	= 1;
				fire	= { 0, 1};
				username	= "Parked";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "Parked",
			}, 
		}, 
	}
)


--F-16I Crew boarding ladder for raised canopy
declare_loadout(
	{
		category		= CAT_PODS,
		CLSID			= "{Crew_Ladder_Dual}",
		attribute		=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture			= "Crew_Ladder.png",
		Weight_Empty	= 0,
		Weight			= 0,
		Cx_pil			= 0,
		displayName		= _("Dual Crew Ladder"),
		
		shape_table_data = 
		{
			{
				name 	= "Crew_Ladder_Dual",
				file	= "Crew_Ladder_Dual";
				life	= 1;
				fire	= { 0, 1};
				username	= "Crew_Ladder_Dual";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "Crew_Ladder_Dual",
			}, 
		}, 
	}
)



--AN/AAQ-13 LANTIRN POD
declare_loadout({
	category 		= CAT_PODS,
	CLSID			= "{AN_AAQ_13}",
	attribute		= {4, 15,	44, WSTYPE_PLACEHOLDER},
	Count 			= 1,
	Weight			= 205,
	Cx_pil			= 0.000244140625,
	Picture			= "AAQ-13.png",
	displayName		= _("AN/AAQ-13 LANTIRN - Targeting Pod"),
	
	shape_table_data =
	{
		{
			name = "ANAAQ-13",
			file = "ANAAQ-13";
			life = 1;
			fire = { 0, 1};
			username = "ANAAQ-13",
			index = WSTYPE_PLACEHOLDER,
		},
	},
	
	Elements		=	
	{
		{
			ShapeName	=	"ANAAQ-13",
		}
	},	
	}
)
